% Demo of ensemble averaging
t=[1:200];
repeats=1000;
Noise=10;
clear A
clf
amp=[1 2 3];  % Amplitudes of the peaks
pos=[length(t)/4 length(t)/2 length(t)/1.33];   % Positions of the peaks
wid=[16 16 16];   % Widths of the peaks
A = zeros(length(pos),length(t));
for k=1:length(pos)
  A(k,:)=gaussian(t,pos(k),wid(k));  % Use any peak function here
end
sum=zeros(size(t));
spectrum=amp*A;  
figure(1);axis([0 length(t) -.5 3.5])
axis manual
axis([0 length(t) -.5 3.5])
for k=1:repeats,
    signal=spectrum+Noise.*randn(size(t));
    sum=sum+signal;
    figure(1);plot(t,sum./k,'.')   
    title('Averaged signal');
    text(20,3.7,['Number of signals averaged = ' num2str(k)])
    axis([0 200 -1 4]);
    drawnow   
    if k==1,
        pause(2)
    end
end
axis auto

