/**
  *  ================================================================
  *  Footprint.java: Create footprint object for AV Williams Building
  * 
  *  Uses: Array lists ....
  *        Triangle.java, Edge.java, Node.java and Vector.java
  * 
  *  Written by: Mark Austin                                 May 2007 
  *  ================================================================
  */

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Footprint {
   String sName;
   List triangle = new ArrayList();

   // ==============================================
   // Set name of the footprint ...
   // ==============================================

   public void setName( String sName ) {
      this.sName = sName;
   }

   // ==============================================
   // Compute total area of footprint ....
   // ==============================================

   public double area() {
      double buildingArea = 0.0;

      // Walk along triangles and sum area ....

      Iterator iterator1 = triangle.iterator();
      while ( iterator1.hasNext() != false ) {
          Triangle tp = (Triangle) iterator1.next();
          buildingArea = buildingArea + tp.area();
      }

      // Return area of building footprint ...

      return buildingArea;
   }

   // ==============================================
   // Compute x coordinate of centroid ....
   // ==============================================

   public double getCentroidX() {
      double buildingArea = area();
      double firstMomentX = 0.0;

      // Compute first moment of area about origin ...

      Iterator iterator1 = triangle.iterator();
      while ( iterator1.hasNext() != false ) {
          Triangle tp = (Triangle) iterator1.next();
          firstMomentX = firstMomentX + tp.area()*tp.getCentroidX();
      }

      return firstMomentX/buildingArea;
   }

   // ==============================================
   // Compute y coordinate of centroid ....
   // ==============================================

   public double getCentroidY() {
      double buildingArea = area();
      double firstMomentY = 0.0;

      // Compute first moment of area about origin ...

      Iterator iterator1 = triangle.iterator();
      while ( iterator1.hasNext() != false ) {
          Triangle tp = (Triangle) iterator1.next();
          firstMomentY = firstMomentY + tp.area()*tp.getCentroidY();
      }

      return firstMomentY/buildingArea;
   }


   // ==============================================
   // Create string description of the footprint ...
   // ==============================================

   public String toString() {
      String s = "Footprint: " + sName + "\n";
      s = s + "=================================\n";

      Iterator iterator1 = triangle.iterator();
      while ( iterator1.hasNext() != false ) {
          Triangle tp = (Triangle) iterator1.next();
          s = s + tp.toString();
      }

      return s;
   }

   // =======================================================
   // Exercise methods in Footprint class .....
   // =======================================================

   public static void main( String args[] ) {

      // Create building footprint object ....

      Footprint avw = new Footprint();
      avw.setName("A.V. Williams Bldg");

      // Create triangles to cover the footprint ...

      Triangle a = new Triangle("a", 1.0, 1.0, 1.0, 6.0, 3.0, 1.0 );
      Triangle b = new Triangle("b", 3.0, 1.0, 1.0, 6.0, 3.0, 6.0 );
      Triangle c = new Triangle("c", 3.0, 4.0, 3.0, 6.0, 7.0, 6.0 );
      Triangle d = new Triangle("d", 3.0, 4.0, 7.0, 6.0, 7.0, 4.0 );
      Triangle e = new Triangle("e", 7.0, 1.0, 7.0, 6.0, 9.0, 1.0 );
      Triangle f = new Triangle("f", 9.0, 1.0, 7.0, 6.0, 9.0, 6.0 );

      // Add triangles to footprint ...

      avw.triangle.add( a );
      avw.triangle.add( b );
      avw.triangle.add( c );
      avw.triangle.add( d );
      avw.triangle.add( e );
      avw.triangle.add( f );

      // Print details of footprint ...

      System.out.println ( avw.toString() );

      // Compute and print the footprint area ...

      System.out.printf ( "*** Footprint Area = %8.3f\n", avw.area() );

      // Compute and print (x,y) coordinates of the centroid...

      System.out.printf ( "*** Centroid: X = %8.3f\n", avw.getCentroidX() );
      System.out.printf ( "            : Y = %8.3f\n", avw.getCentroidY() );
   }
}
