/*
 *  ==========================================================================
 *  Triangle.java : This Java 2 program prompts a user for three pairs of
 *  (x,y) coordinates and computes and prints the perimeter and area of the
 *  triangle.
 *
 *  Written By : Mark Austin                                    December, 2002
 *  ==========================================================================
 */

import java.lang.Math;
import java.util.*;
import java.io.*;
import java.text.*;

public class Triangle {
    protected Node node1, node2, node3;
    protected Edge edge1, edge2, edge3;
    protected String sName;

    // Constructor methods ....

    public Triangle() {}

    public Triangle( double dX1, double dY1,
                     double dX2, double dY2,
                     double dX3, double dY3 ) {

       this.sName = null;
       this.node1    = new Node();
       this.node2    = new Node();
       this.node3    = new Node();

       node1.dX = dX1; node1.dY = dY1; node2.setName ("n1");
       node2.dX = dX2; node2.dY = dY2; node3.setName ("n2");
       node3.dX = dX3; node3.dY = dY3; node1.setName ("n3");

       this.edge1 = new Edge( "e1", this.node1, this.node2 );
       this.edge2 = new Edge( "e2", this.node2, this.node3 );
       this.edge3 = new Edge( "e3", this.node3, this.node1 );
    }

    public Triangle( String sName, double dX1, double dY1,
                                   double dX2, double dY2,
                                   double dX3, double dY3 ) {

       this.sName = sName;
       this.node1 = new Node();
       this.node2 = new Node();
       this.node3 = new Node();

       node1.dX = dX1; node1.dY = dY1; node2.setName ("n1");
       node2.dX = dX2; node2.dY = dY2; node3.setName ("n2");
       node3.dX = dX3; node3.dY = dY3; node1.setName ("n3");

       this.edge1 = new Edge( "e1", this.node1, this.node2 );
       this.edge2 = new Edge( "e2", this.node2, this.node3 );
       this.edge3 = new Edge( "e3", this.node3, this.node1 );
    }

    //  ===================================================
    //  Retrieve X and Y coordinates of a polygon point....
    //  ===================================================

    public double getCentroidX() {
       return ( node1.dX + node2.dX + node3.dX )/3.0;
    }

    public double getCentroidY() {
       return ( node1.dY + node2.dY + node3.dY )/3.0;
    }

    // =====================================
    // Compute perimeter of triangle ....
    // =====================================

    public double perimeter() {
        return edge1.length() + edge2.length() + edge3.length();
    }

    // =====================================
    // Compute area of triangle ....
    // =====================================

    public double area() {
        double dS = perimeter()/2.0;
        double dArea = Math.sqrt( dS*(dS - edge1.length()) *
                                     (dS - edge2.length()) *
                                     (dS - edge3.length()) );
        return dArea;
    }

    // Convert details of triangle to a string ...

    public String toString() {
        return "Triangle: \"" + sName + "\"\n" +
               "================================= \n" +
               edge1.toString() + "\n" +
               edge2.toString() + "\n" +
               edge3.toString() + "\n" +
               node1.toString() + "\n" +
               node2.toString() + "\n" +
               node3.toString() + "\n" +
               "================================= \n";
    }

    // Exercise methods in triangle class ....

    public static void main( String args[] ) {

        // Create a test triangle ....

        Triangle t = new Triangle( "A", 1.0, 1.0,
                                        2.0, 1.0,
                                        2.0, 2.0 );

        // Print details of the triangle ....

        System.out.println( t.toString() );
        System.out.println("Perimeter = " + t.perimeter() );
        System.out.println("Area      = " + t.area() );
    }
}
